function features = getTextureFeatures(im, x, y, sizeWin)
    n_feat = 11; %this
    features = zeros(1,n_feat*length(sizeWin));
    for s = 1:length(sizeWin)
        window = im(x-sizeWin(s)/2:x+sizeWin(s)/2,y-sizeWin(s)/2:y+sizeWin(s)/2);
        h = imhist(window,16);
        h=h/sum(h);
        cv = std2(window)/mean2(window);
        skew = skewness(h);
        curt = kurtosis(h);
        ener = sum(h/sum(h).*h/sum(h));
        entr = entropy(h);
        G = graycomatrix(window,'symmetric', true, 'Offset', [1,1],'NumLevels',16);
        p=graycoprops(G);
        start = 1+n_feat*(s-1);
        features(start:start+n_feat-1) = [mean2(window), std2(window),  cv, skew, curt, ener, entr, p.Contrast,p.Correlation,p.Energy,p.Homogeneity]; %this
    end
end